/**
 * 
 */
package gov.va.med.mhv.bluebutton.converter;

import gov.va.med.mhv.bluebutton.model.PhrRadiology;
import gov.va.med.mhv.bluebutton.transfer.PhrRadiologyDTO;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class PhrRadiologyConverter implements Converter<PhrRadiology, PhrRadiologyDTO> {

	@Override
	public PhrRadiologyDTO convert(PhrRadiology s) {
		PhrRadiologyDTO d = new PhrRadiologyDTO();
		
		d.setId(s.getId());
		d.setReasonForStudy(s.getReasonForStudy());
		d.setRadiologist(s.getRadiologist());
		d.setClinicalHistory(s.getClinicalHistory());
		d.setComments(s.getComments());
		d.setCreatedDate(s.getCreatedDate());
		d.setImpressionText(s.getImpressionText());
		d.setInPatientOutPatient(s.getInPatientOutPatient());
		d.setOplock(s.getOplock());
		d.setStationNumber(s.getStationNumber());
		d.setPatientId(s.getPatientId());
		d.setProcedureName(s.getProcedureName());
		d.setStatus(s.getStatus());
		d.setRequestingProvider(s.getRequestingProvider());
		d.setReportText(s.getReportText());
		d.setPerformingLocationStNum(s.getPerformingLocationStNum());
		d.setEventDate(s.getEventDate().getDatePrecise());
		d.setExamDate(s.getExamDate().getDatePrecise());

		return d;
	}
	
}
